#include <avr/io.h>
#include "dcfroutines.h"


	
void dcf_init(void)
{
	DDRD |= (1<<PD1);
	DDRD &= ~(1<<PD0);
	zustand = warte_4s;													// Anfangszustand
	dcf_count = 0;														// Zähler auf null
	dcf_timer = 0;
}


/*----------------------------------------------------------------------------
--------------------------------DCF - Abfrage---------------------------------
--------Diese Routine muss 1x/ms ausgeführt werden in einem Interrupt-------*/


void dcf_interrupt(void)
{
		if (bit_is_set(PIND, PD0)) 					
		dcf.z = 1;
	else
		dcf.z = 0;
	
	// ZUSTAND: 4s warten (bis gültige Daten empfangen werden)
	
	if (zustand == warte_4s)					 
	{
		PORTD &= ~PD1;							// Empfänger an
		
		if (dcf_timer == 4000)					// schon 4s vergangen ?
		{
			dcf_timer = 0;						// ja: Zähler auf null,
			zustand = minstart;					// nächster Zustand
		}
		else 
			dcf_timer++;						// sonst: weiterzählen
	}
	
	// ZUSTAND: Warten auf Minutenmarke
	
	if (zustand == minstart)					
	{
		if ((dcf.z == 0) || (dcf.z_1 == 0) || (dcf.z_2 == 0))
		{
			dcf_timer++;						// DCF auf 1 ? nein: weiterzählen
			if (dcf_timer == 1500)				// Zähler schon bei 1500 ? (1,5s / 1ms = 1500)
			{
				dcf_timer = 0;					// ja, Zähler auf null
				dcf_count = 0;					// zur Sicherheit dcf_count nochmal auf null
				zustand = dcf_1;				// neuer Zustand: 1.Datensatz empfangen
			}
		}
		else
			dcf_timer = 0;						// sonst Zähler zurück auf 0
	}
	
	// ZUSTAND: Datensatz empfangen
	
	if ((zustand == dcf_1) || (zustand == dcf_2))						
	{
		if ((dcf.z_2 == 0) && (!((dcf.z_1 == 1) && (dcf.z == 1))))
			dcf_timer = 0;						// Signal L: Timer auf 0
		
		else
		
			if ((dcf.z_2 == 1) && (dcf.z_1 == 0) && (dcf.z == 0))
			{
				dcf_auswertung();				// nach HL-Flanke: Auswertung aufrufen
				dcf_timer = 0;					// Timer zurück auf 0
			}
			
			else
				dcf_timer++;					// Signal H: Timer inkrementieren
		
		if (dcf_count == 59)					// dcf_count = 59: letztes Bit wurde empfangen !
		{
			if (parcheck() == 1)				// wenn Parity in Ordnung:
			{
					if (zustand == dcf_1)		// Bei 1. Datensatz:
					{
						dcf_copy();				// Datensatz nach dcf_1 schieben und inkrementieren
						zustand = dcf_2;		// 2. Datensatz empfangen
					}
					else						// Bei 2. Datensatz
						dcf_check();			// Check und evtl. Übernahme
			}
			else								// fehlerhafte Parity:
				zustand = minstart;				// neue Minutenmarke abwarten
			
			dcf_count = 0;						// Zähler zurück auf null
		}
	}
	
	// ZUSTAND: Datenübernahme
	
	if (zustand == data_ready)
	{
		if (dcf.z == 1)							// Warte bis zur Minutenmarke
		{
			sekunde.einer = 0;					// Uhr synchronisieren
			sekunde.zehner = 0;
			//clock_count = 0;
			
			minute.einer = dcf_min.einer;
			minute.zehner = dcf_min.zehner;
			
			stunde.einer = dcf_std.einer;
			stunde.zehner = dcf_std.zehner;
			
			tag.einer = dcf_tag.einer;
			tag.zehner = dcf_tag.zehner;
			
			monat.einer = dcf_monat.einer;
			monat.zehner = dcf_monat.zehner;
			monat.wochentag = dcf_monat.wochentag;
			
			jahr.einer = dcf_jahr.einer;
			jahr.zehner = dcf_jahr.zehner;
			
			zustand = synchron;
			
			PORTD |= PD1;						// Empfänger aus
		}
	}
	
	// ZUSTAND: Synchron - Warten bis zur nächsten Synchronisation um 3:00 Uhr
	
	if (zustand == synchron)
	{
		if ((stunde.zehner == 0) && (stunde.einer == 3) && (minute.zehner == 0) && (minute.einer == 0))
			
			zustand = warte_4s;
	}
		
	dcf.z_2 = dcf.z_1;							// Zustände abspeichern für nächsten Interrupt
	dcf.z_1 = dcf.z;
}


/*----------------------------------------------------------------------------
----------------------------DCF - Auswertung--------------------------------*/

void dcf_auswertung(void)
{
	if (dcf_count == 0)						// wenn Dekodierung beginnt: alles auf null
	{
		dcf_min.einer = 0;
		dcf_min.zehner = 0;
		dcf_min.parity = 0;
		dcf_std.einer = 0;
		dcf_std.zehner = 0;
		dcf_std.parity = 0;
		dcf_tag.einer = 0;
		dcf_tag.zehner = 0;
		dcf_tag.parity = 0;
		dcf_monat.einer = 0;
		dcf_monat.zehner = 0;
		dcf_monat.wochentag = 0;
		dcf_jahr.einer = 0;
		dcf_jahr.zehner = 0;
	}
	
	if (dcf_timer > 65)							// Mindestimpulsdauer 70ms
	{
		if (dcf_timer > 145)						// Impuls >= 150ms: High-Bit
		
			switch(dcf_count)
			{
				case 21:	{	dcf_min.einer++; 			break;	}
				case 22:	{	dcf_min.einer += 2;			break; }
				case 23:	{	dcf_min.einer += 4;			break; }
				case 24:	{	dcf_min.einer += 8;			break; }
				case 25:	{ 	dcf_min.zehner++;			break; }
				case 26:	{ 	dcf_min.zehner += 2;		break; }
				case 27: 	{	dcf_min.zehner += 4;		break; }
				case 28:	{	dcf_min.parity = 1;			break; }
				
				case 29: 	{ 	dcf_std.einer++;			break; }
				case 30:	{ 	dcf_std.einer += 2;			break; }
				case 31:	{ 	dcf_std.einer += 4;			break; }
				case 32:	{	dcf_std.einer += 8;			break; }
				case 33:	{	dcf_std.zehner++;			break; }
				case 34:	{	dcf_std.zehner += 2;		break; }
				case 35:	{	dcf_std.parity = 1;			break; }
				
				case 36:	{	dcf_tag.einer++;			break; }
				case 37:	{	dcf_tag.einer += 2;			break; }
				case 38:	{	dcf_tag.einer += 4;			break; }
				case 39:	{ 	dcf_tag.einer += 8;			break; }
				case 40:	{	dcf_tag.zehner++;			break; }
				case 41:	{	dcf_tag.zehner += 2;		break; }
				
				case 42:	{ 	dcf_monat.wochentag++;		break; }
				case 43:	{	dcf_monat.wochentag += 2;	break; }
				case 44:	{	dcf_monat.wochentag += 4;	break; }
				
				case 45:	{	dcf_monat.einer++;			break; }
				case 46:	{	dcf_monat.einer += 2;		break; }
				case 47:	{	dcf_monat.einer += 4;		break; }
				case 48:	{	dcf_monat.einer += 8;		break; }
				case 49:	{	dcf_monat.zehner++;			break; }
				
				case 50:	{	dcf_jahr.einer++;			break; }
				case 51:	{	dcf_jahr.einer += 2;		break; }
				case 52:	{	dcf_jahr.einer += 4;		break; }
				case 53: 	{	dcf_jahr.einer += 8;		break; }
				case 54:	{	dcf_jahr.zehner++;			break; }
				case 55:	{	dcf_jahr.zehner += 2;		break; }
				case 56:	{ 	dcf_jahr.zehner += 4;		break; }
				case 57:	{	dcf_jahr.zehner += 8;		break; }
				
				default:		dcf_tag.parity = 1;		
			}
		
			dcf_count++;
	}
}

/*----------------------------------------------------------------------------
------------------------------Parity-Check----------------------------------*/

int parcheck(void)
{
	// Vereinfachter Parity-Check nur für Minuten und Stunden 
	// (Fehlererkennung erfolgt hauptsächlich durch den Folge-Check)
	
	if ((dcf_min.einer == 0) || (dcf_min.einer == 3) || (dcf_min.einer == 5) || (dcf_min.einer == 6) || (dcf_min.einer == 9))
	
		if ((dcf_min.zehner == 0) || (dcf_min.zehner == 3) || (dcf_min.zehner == 5))
		{
			if (dcf_min.parity == 1)
				
				return 0;
		}
		else
		{
			if (dcf_min.parity == 0)
			
				return 0;
		}
		
	else
	
		if ((dcf_min.zehner == 0) || (dcf_min.zehner == 3) || (dcf_min.zehner == 5))
		{
			if (dcf_min.parity == 0)
				
				return 0;
		}
		else
		{
			if (dcf_min.parity == 1)
			
				return 0;
		}
	
	if ((dcf_std.einer == 0) || (dcf_std.einer == 3) || (dcf_std.einer == 5) || (dcf_std.einer == 6) || (dcf_std.einer == 9))
	
		if (dcf_std.zehner == 0)
		{
			if (dcf_std.parity == 1)
				
				return 0;
		}
		else
		{
			if (dcf_std.parity == 0)
			
				return 0;
		}
		
	else
	
		if (dcf_std.zehner == 0)
		{
			if (dcf_std.parity == 0)
				
				return 0;
		}
		else
		{
			if (dcf_std.parity == 1)
			
				return 0;
		}
	
	return 1;
}


/*----------------------------------------------------------------------------
----------------------------Datensatz 1 -> 2 -------------------------------*/


void dcf_copy(void)
{
	dcf_min1 = dcf_min;							// Kopiere Strukturen
	dcf_std1 = dcf_std;
	dcf_tag1 = dcf_tag;
	dcf_monat1 = dcf_monat;
	dcf_jahr1 = dcf_jahr;
	
	// Inkrementieren des ersten Datensatzes
	// (Beschränkung auf Stunden und Minuten, dadurch einfacherer Code;
	//		nur beim Tagesüberlauf ergibt sich ein Fehler, so dass erneut
	//		empfangen werden muss)
	
	if (dcf_min1.einer < 9)
		dcf_min1.einer++;
	
	else
	{
		dcf_min1.einer = 0;
		
		if (dcf_min1.zehner < 5)
			dcf_min1.zehner++;
		
		else
		{
			dcf_min1.zehner = 0;
			
			if ((dcf_std1.einer == 3) && (dcf_std1.zehner == 2))
			{
				dcf_std1.einer = 0;
				dcf_std1.zehner = 0;
			}
			else if (dcf_std1.einer == 9)
				{
					dcf_std1.einer = 0;
					dcf_std1.zehner++;
				}
				else
					dcf_std1.einer++;
		}
	}
}

void dcf_check(void)
{
	if ((dcf_min.einer == dcf_min1.einer) && (dcf_min.zehner == dcf_min1.zehner) && (dcf_std.einer == dcf_std.einer) && (dcf_std.zehner == dcf_std1.zehner) && (dcf_tag.einer == dcf_tag1.einer) && (dcf_tag.zehner == dcf_tag1.zehner) && (dcf_monat.einer == dcf_monat1.einer) && (dcf_monat.zehner == dcf_monat1.zehner) && (dcf_monat.wochentag == dcf_monat1.wochentag) && (dcf_jahr.einer == dcf_jahr1.einer) && (dcf_jahr.zehner == dcf_jahr1.zehner))
	
		zustand = data_ready;					// Vergleich erfolgreich: Bereit zur Datenübernahme  
		
	else
	
		zustand = minstart;						// Vergleich fehlerhaft: Neubeginn beim nächsten Minutenstart
	
	dcf_count = 0;
}

//@}